<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use App\Models\User;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use Spatie\Permission\Models\Role;

class RegisterController extends Controller {
	/*
	|--------------------------------------------------------------------------
	| Register Controller
	|--------------------------------------------------------------------------
	|
	| This controller handles the registration of new users as well as their
	| validation and creation. By default this controller uses a trait to
	| provide this functionality without requiring any additional code.
	|
	 */

	use RegistersUsers;

	/**
	 * Where to redirect users after registration.
	 *
	 * @var string
	 */
	protected $redirectTo = RouteServiceProvider::HOME;

	/**
	 * Create a new controller instance.
	 *
	 * @return void
	 */
	public function __construct() {
		$this->middleware('guest');
	}

	/**
	 * Get a validator for an incoming registration request.
	 *
	 * @param  array  $data
	 * @return \Illuminate\Contracts\Validation\Validator
	 */
	protected function validator(array $data) {
		return Validator::make($data, [
				'roles'                => ['required', 'numeric'],
				'first_name'           => ['required', 'string', 'max:255'],
				'last_name'            => ['required', 'string', 'max:255'],
				'phone'                => ['required', 'string', Rule::unique("users", "phone"),'max:255'],
				'address'              => ['nullable', 'string', 'max:255'],
				'email'                => ['required', 'string', Rule::unique("users", "email"), 'email', 'max:100'],
				'username'             => request('username')?['required', 'string', Rule::unique("users", "username"), 'max:60']:['nullable'],
				'password'             => ['required', 'string', 'min:6', 'confirmed'],
				'terms_and_conditions' => ['accepted']
			]);
	}

	/**
	 * Create a new user instance after a valid registration.
	 *
	 * @param  array  $data
	 * @return \App\Models\User
	 */
	protected function create(array $data) {
		$user = User::create([
				'first_name' => $data['first_name'],
				'last_name'  => $data['last_name'],
				'username'   => $data['username']??$this->username($data['email']),
				'phone'      => $data['phone'],
				'address'    => $data['address'],
				'email'      => $data['email'],
				'password'   => Hash::make($data['password']),
			]);

		$role = Role::find($data['roles']);
		if (!blank($user) && !blank($role)) {
			$user->assignRole($role->name);
		}
		return $user;
	}

	private function username($email) {
		$emails = explode('@', $email);
		return $emails[0].mt_rand();
	}
}
