@extends('frontend.layouts.frontend')

@section('content')
<section id="pm-banner-1" class="pm-banner-section-1 custom-css qr-section">
    <div class="container text-center my-10">
        <div id="print-area" class="flex flex-col items-center justify-center">
            <p class="mb-6">{{__('Scan This QR Code For Getting Access To Visit The Employee.') }}</p>
            <img class="mb-6" src="{{ $visitor->qrcode }}" alt="" style="width: 300px;">

            <button onclick="printQR()" class="qrbtn bg-red-600 hover:bg-red-700 text-white px-5 py-2 rounded flex items-center gap-2 shadow-md">
                <i class="fa-solid fa-file-pdf"></i>
                <span>{{ __('Download as PDF') }}</span>
            </button>
        </div>
    </div>
</section>

<style>
    @media print {
        .qrbtn {
            display: none !important;
        }

        body {
            background: white !important;
        }

        body * {
            visibility: hidden;
        }

        #print-area, #print-area * {
            visibility: visible;
        }

        #print-area {
            position: absolute;
            left: 0;
            top: 0;
            width: 100%;
            padding: 40px;
            background: white;
        }

        #print-area {
            border: 1px solid #ddd;
            border-radius: 12px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
        }

        #print-area p {
            font-size: 18px;
            font-weight: 500;
            color: #333;
        }

        #print-area img {
            margin: 20px auto;
            display: block;
            width: 250px !important;
        }

        #print-area::before {
            content: "Visitor Access QR Code";
            display: block;
            text-align: center;
            font-size: 24px;
            font-weight: bold;
            color: #222;
            margin-bottom: 10px;
        }
    }
</style>

<script>
    function printQR() {
        window.print();
    }
</script>
@endsection
