<?php $__env->startSection('content'); ?>
<div class="mb-9">
    <div class="row">
        <div class="col-12">
            <?php if(env('DEMO')): ?>
            <div class="p-2 pl-4 mb-4 bg-red-100 rounded">
                <h2 class="mb-1">Reminder!</h2>
                <p>Dummy data will be reset in every 30 minutes.</p>
            </div>
            <?php endif; ?>
            <div class="mb-8">
                <h3 class="font-semibold text-[26px] leading-10 capitalize text-primary"><?php echo e(getGreeting()); ?></h3>
                <h4 class="font-medium text-[22px] leading-[34px] capitalize"><?php echo e(Auth::user()->name); ?></h4>
            </div>
            <div class="mb-9">
                <h4 class="font-semibold text-[22px] leading-[34px] mb-3 capitalize"><?php echo e(__('all.overview')); ?></h4>
                <div class="row">
                    <?php if(auth()->user()->getrole->id == \App\Enums\UserRole::ADMIN): ?>
                    <div  class = "col-12 sm:col-6 xl:col-3">
                    <a    href  = "<?php echo e(route('admin.employees.index')); ?>" class                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    = "w-full">
                    <div  class = "p-4 rounded-lg flex items-center gap-4 bg-primary">
                    <div  class = "flex items-center justify-center w-12 h-12 bg-white rounded-full">
                    <svg  width = "24" height                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     = "24" viewBox = "0 0 24 24" fill = "none" xmlns = "http://www.w3.org/2000/svg">
                    <path d     = "M12.75 15.92H13.4C14.05 15.92 14.59 15.34 14.59 14.64C14.59 13.77 14.28 13.6 13.77 13.42L12.76 13.07V15.92H12.75Z" fill                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        = "#002793" />
                    <path d     = "M11.9701 1.89998C6.45007 1.91998 1.98007 6.40998 2.00007 11.93C2.02007 17.45 6.51007 21.92 12.0301 21.9C17.5501 21.88 22.0201 17.39 22.0001 11.87C21.9801 6.34998 17.4901 1.88998 11.9701 1.89998ZM14.2601 12C15.0401 12.27 16.0901 12.85 16.0901 14.64C16.0901 16.18 14.8801 17.42 13.4001 17.42H12.7501V18C12.7501 18.41 12.4101 18.75 12.0001 18.75C11.5901 18.75 11.2501 18.41 11.2501 18V17.42H10.8901C9.25007 17.42 7.92007 16.04 7.92007 14.34C7.92007 13.93 8.26007 13.59 8.67007 13.59C9.08007 13.59 9.42007 13.93 9.42007 14.34C9.42007 15.21 10.0801 15.92 10.8901 15.92H11.2501V12.54L9.74007 12C8.96007 11.73 7.91007 11.15 7.91007 9.35998C7.91007 7.81998 9.12007 6.57998 10.6001 6.57998H11.2501V5.99998C11.2501 5.58998 11.5901 5.24998 12.0001 5.24998C12.4101 5.24998 12.7501 5.58998 12.7501 5.99998V6.57998H13.1101C14.7501 6.57998 16.0801 7.95998 16.0801 9.65998C16.0801 10.07 15.7401 10.41 15.3301 10.41C14.9201 10.41 14.5801 10.07 14.5801 9.65998C14.5801 8.78998 13.9201 8.07998 13.1101 8.07998H12.7501V11.46L14.2601 12Z" fill = "#002793" />
                    <path d     = "M9.41992 9.37002C9.41992 10.24 9.72992 10.41 10.2399 10.59L11.2499 10.94V8.08002H10.5999C9.94992 8.08002 9.41992 8.66002 9.41992 9.37002Z" fill                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                = "#002793" />
                                    </svg>
                                </div>
                                <div>
                                    <h3 class="font-medium text-white"><?php echo e(__('all.total_employees')); ?></h3>
                                    <h4 class="font-semibold text-[22px] leading-[34px] text-white">
                                        <?php echo e($totalEmployees); ?></h4>
                                </div>
                            </div>
                        </a>
                    </div>
                    <?php endif; ?>
                    <div class="col-12 sm:col-6 xl:col-3">
                        <a href="<?php echo e(route('admin.visitors.index')); ?>" class="w-full">
                            <div class="p-4 rounded-lg flex items-center gap-4 bg-[#8262FE]">
                                <div class="flex items-center justify-center w-12 h-12 bg-white rounded-full">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M20.2102 7.82L12.5102 12.28C12.2002 12.46 11.8102 12.46 11.4902 12.28L3.79021 7.82C3.24021 7.5 3.10021 6.75 3.52021 6.28C3.81021 5.95 4.14021 5.68 4.49021 5.49L9.91021 2.49C11.0702 1.84 12.9502 1.84 14.1102 2.49L19.5302 5.49C19.8802 5.68 20.2102 5.96 20.5002 6.28C20.9002 6.75 20.7602 7.5 20.2102 7.82Z" fill="#8262FE" />
                                        <path d="M11.4305 14.14V20.96C11.4305 21.72 10.6605 22.22 9.98047 21.89C7.92047 20.88 4.45047 18.99 4.45047 18.99C3.23047 18.3 2.23047 16.56 2.23047 15.13V9.97C2.23047 9.18 3.06047 8.68 3.74047 9.07L10.9305 13.24C11.2305 13.43 11.4305 13.77 11.4305 14.14Z" fill="#8262FE" />
                                        <path d="M12.5703 14.14V20.96C12.5703 21.72 13.3403 22.22 14.0203 21.89C16.0803 20.88 19.5503 18.99 19.5503 18.99C20.7703 18.3 21.7703 16.56 21.7703 15.13V9.97C21.7703 9.18 20.9403 8.68 20.2603 9.07L13.0703 13.24C12.7703 13.43 12.5703 13.77 12.5703 14.14Z" fill="#8262FE" />
                                    </svg>
                                </div>
                                <div>
                                    <h3 class="font-medium text-white"><?php echo e(__('all.total_visitors')); ?></h3>
                                    <h4 class="font-semibold text-[22px] leading-[34px] text-white"><?php echo e($totalVisitor); ?>

                                    </h4>
                                </div>
                            </div>
                        </a>
                    </div>
                    <div class="col-12 sm:col-6 xl:col-3">
                        <a href="<?php echo e(route('admin.pre-registers.index')); ?>" class="w-full">
                            <div class="p-4 rounded-lg flex items-center gap-4 bg-[#567DFF]">
                                <div class="flex items-center justify-center w-12 h-12 bg-white rounded-full">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M9 2C6.38 2 4.25 4.13 4.25 6.75C4.25 9.32 6.26 11.4 8.88 11.49C8.96 11.48 9.04 11.48 9.1 11.49C9.12 11.49 9.13 11.49 9.15 11.49C9.16 11.49 9.16 11.49 9.17 11.49C11.73 11.4 13.74 9.32 13.75 6.75C13.75 4.13 11.62 2 9 2Z" fill="#567DFF" />
                                        <path d="M14.08 14.15C11.29 12.29 6.73996 12.29 3.92996 14.15C2.65996 15 1.95996 16.15 1.95996 17.38C1.95996 18.61 2.65996 19.75 3.91996 20.59C5.31996 21.53 7.15996 22 8.99996 22C10.84 22 12.68 21.53 14.08 20.59C15.34 19.74 16.04 18.6 16.04 17.36C16.03 16.13 15.34 14.99 14.08 14.15Z" fill="#567DFF" />
                                        <path d="M19.9904 7.33998C20.1504 9.27998 18.7704 10.98 16.8604 11.21C16.8504 11.21 16.8504 11.21 16.8404 11.21H16.8104C16.7504 11.21 16.6904 11.21 16.6404 11.23C15.6704 11.28 14.7804 10.97 14.1104 10.4C15.1404 9.47998 15.7304 8.09998 15.6104 6.59998C15.5404 5.78998 15.2604 5.04998 14.8404 4.41998C15.2204 4.22998 15.6604 4.10998 16.1104 4.06998C18.0704 3.89998 19.8204 5.35998 19.9904 7.33998Z" fill="#567DFF" />
                                        <path d="M21.9902 16.59C21.9102 17.56 21.2902 18.4 20.2502 18.97C19.2502 19.52 17.9902 19.78 16.7402 19.75C17.4602 19.1 17.8802 18.29 17.9602 17.43C18.0602 16.19 17.4702 15 16.2902 14.05C15.6202 13.52 14.8402 13.1 13.9902 12.79C16.2002 12.15 18.9802 12.58 20.6902 13.96C21.6102 14.7 22.0802 15.63 21.9902 16.59Z" fill="#567DFF" />
                                    </svg>
                                </div>
                                <div>
                                    <h3 class="font-medium text-white"><?php echo e(__('all.total_pre_registers')); ?></h3>
                                    <h4 class="font-semibold text-[22px] leading-[34px] text-white">
                                        <?php echo e($totalPrerigister); ?></h4>
                                </div>
                            </div>
                        </a>
                    </div>
                    <?php if(auth()->user()->getrole->id == \App\Enums\UserRole::ADMIN): ?>
                    <div class="col-12 sm:col-6 xl:col-3">
                        <a href="<?php echo e(route('admin.attendance.index')); ?>" class="w-full">
                            <div class="p-4 rounded-lg flex items-center gap-4 bg-[#A953FF]">
                                <div class="flex items-center justify-center w-12 h-12 bg-white rounded-full">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M16 2H8C4.5 2 3 4 3 7V17C3 20 4.5 22 8 22H16C19.5 22 21 20 21 17V7C21 4 19.5 2 16 2ZM8 12.25H12C12.41 12.25 12.75 12.59 12.75 13C12.75 13.41 12.41 13.75 12 13.75H8C7.59 13.75 7.25 13.41 7.25 13C7.25 12.59 7.59 12.25 8 12.25ZM16 17.75H8C7.59 17.75 7.25 17.41 7.25 17C7.25 16.59 7.59 16.25 8 16.25H16C16.41 16.25 16.75 16.59 16.75 17C16.75 17.41 16.41 17.75 16 17.75ZM18.5 9.25H16.5C14.98 9.25 13.75 8.02 13.75 6.5V4.5C13.75 4.09 14.09 3.75 14.5 3.75C14.91 3.75 15.25 4.09 15.25 4.5V6.5C15.25 7.19 15.81 7.75 16.5 7.75H18.5C18.91 7.75 19.25 8.09 19.25 8.5C19.25 8.91 18.91 9.25 18.5 9.25Z" fill="#A953FF" />
                                    </svg>
                                </div>
                                <div>
                                    <h3 class="font-medium text-white"><?php echo e(__('all.today_attendance')); ?></h3>
                                    <h4 class="font-semibold text-[22px] leading-[34px] text-white">
                                        <?php echo e($todayAttendance); ?></h4>
                                </div>
                            </div>
                        </a>
                    </div>
                    <?php else: ?>
                    <div class="col-12 sm:col-6 xl:col-3">
                        <a href="<?php echo e(route('admin.attendance.index')); ?>" class="w-full">
                            <div class="p-4 rounded-lg flex items-center gap-4 bg-[#A953FF]">
                                <div class="flex items-center justify-center w-12 h-12 bg-white rounded-full">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M16 2H8C4.5 2 3 4 3 7V17C3 20 4.5 22 8 22H16C19.5 22 21 20 21 17V7C21 4 19.5 2 16 2ZM8 12.25H12C12.41 12.25 12.75 12.59 12.75 13C12.75 13.41 12.41 13.75 12 13.75H8C7.59 13.75 7.25 13.41 7.25 13C7.25 12.59 7.59 12.25 8 12.25ZM16 17.75H8C7.59 17.75 7.25 17.41 7.25 17C7.25 16.59 7.59 16.25 8 16.25H16C16.41 16.25 16.75 16.59 16.75 17C16.75 17.41 16.41 17.75 16 17.75ZM18.5 9.25H16.5C14.98 9.25 13.75 8.02 13.75 6.5V4.5C13.75 4.09 14.09 3.75 14.5 3.75C14.91 3.75 15.25 4.09 15.25 4.5V6.5C15.25 7.19 15.81 7.75 16.5 7.75H18.5C18.91 7.75 19.25 8.09 19.25 8.5C19.25 8.91 18.91 9.25 18.5 9.25Z" fill="#A953FF" />
                                    </svg>
                                </div>
                                <div>
                                    <h3 class="font-medium text-white"><?php echo e(__('all.today_attendance')); ?></h3>
                                    <h4 class="font-semibold text-[22px] leading-[34px] text-white">
                                        <?php echo e($employeesAttendance); ?></h4>
                                </div>
                            </div>
                        </a>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-12 lg:col-6">
            <div class="db-card">
                <div class="db-card-header">
                    <h3 class="db-card-title"><?php echo e(__('all.preregistered_visitors')); ?></h3>
                    <div id="pregister-date-range" class="cursor-pointer flex items-center gap-3">
                        <span class="capitalize text-base font-medium text-heading"></span>
                        <svg class="fill-primary" width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M16.7502 3.56V2C16.7502 1.59 16.4102 1.25 16.0002 1.25C15.5902 1.25 15.2502 1.59 15.2502 2V3.5H8.75023V2C8.75023 1.59 8.41023 1.25 8.00023 1.25C7.59023 1.25 7.25023 1.59 7.25023 2V3.56C4.55023 3.81 3.24023 5.42 3.04023 7.81C3.02023 8.1 3.26023 8.34 3.54023 8.34H20.4602C20.7502 8.34 20.9902 8.09 20.9602 7.81C20.7602 5.42 19.4502 3.81 16.7502 3.56Z" fill="#002793" />
                            <path opacity="0.4" d="M20 9.84C20.55 9.84 21 10.29 21 10.84V17C21 20 19.5 22 16 22H8C4.5 22 3 20 3 17V10.84C3 10.29 3.45 9.84 4 9.84H20Z" fill="#002793" />
                            <path d="M8.5 15C8.24 15 7.98 14.89 7.79 14.71C7.61 14.52 7.5 14.26 7.5 14C7.5 13.74 7.61 13.48 7.79 13.29C8.07 13.01 8.51 12.92 8.88 13.08C9.01 13.13 9.12 13.2 9.21 13.29C9.39 13.48 9.5 13.74 9.5 14C9.5 14.26 9.39 14.52 9.21 14.71C9.02 14.89 8.76 15 8.5 15Z" fill="#002793" />
                            <path d="M12 15C11.74 15 11.48 14.89 11.29 14.71C11.11 14.52 11 14.26 11 14C11 13.74 11.11 13.48 11.29 13.29C11.38 13.2 11.49 13.13 11.62 13.08C11.99 12.92 12.43 13.01 12.71 13.29C12.89 13.48 13 13.74 13 14C13 14.26 12.89 14.52 12.71 14.71C12.66 14.75 12.61 14.79 12.56 14.83C12.5 14.87 12.44 14.9 12.38 14.92C12.32 14.95 12.26 14.97 12.2 14.98C12.13 14.99 12.07 15 12 15Z" fill="#002793" />
                            <path d="M15.5 15C15.24 15 14.98 14.89 14.79 14.71C14.61 14.52 14.5 14.26 14.5 14C14.5 13.74 14.61 13.48 14.79 13.29C14.89 13.2 14.99 13.13 15.12 13.08C15.3 13 15.5 12.98 15.7 13.02C15.76 13.03 15.82 13.05 15.88 13.08C15.94 13.1 16 13.13 16.06 13.17C16.11 13.21 16.16 13.25 16.21 13.29C16.39 13.48 16.5 13.74 16.5 14C16.5 14.26 16.39 14.52 16.21 14.71C16.16 14.75 16.11 14.79 16.06 14.83C16 14.87 15.94 14.9 15.88 14.92C15.82 14.95 15.76 14.97 15.7 14.98C15.63 14.99 15.56 15 15.5 15Z" fill="#002793" />
                            <path d="M8.5 18.5C8.37 18.5 8.24 18.47 8.12 18.42C7.99 18.37 7.89 18.3 7.79 18.21C7.61 18.02 7.5 17.76 7.5 17.5C7.5 17.24 7.61 16.98 7.79 16.79C7.89 16.7 7.99 16.63 8.12 16.58C8.3 16.5 8.5 16.48 8.7 16.52C8.76 16.53 8.82 16.55 8.88 16.58C8.94 16.6 9 16.63 9.06 16.67C9.11 16.71 9.16 16.75 9.21 16.79C9.39 16.98 9.5 17.24 9.5 17.5C9.5 17.76 9.39 18.02 9.21 18.21C9.16 18.25 9.11 18.3 9.06 18.33C9 18.37 8.94 18.4 8.88 18.42C8.82 18.45 8.76 18.47 8.7 18.48C8.63 18.49 8.57 18.5 8.5 18.5Z" fill="#002793" />
                            <path d="M12 18.5C11.74 18.5 11.48 18.39 11.29 18.21C11.11 18.02 11 17.76 11 17.5C11 17.24 11.11 16.98 11.29 16.79C11.66 16.42 12.34 16.42 12.71 16.79C12.89 16.98 13 17.24 13 17.5C13 17.76 12.89 18.02 12.71 18.21C12.52 18.39 12.26 18.5 12 18.5Z" fill="#002793" />
                            <path d="M15.5 18.5C15.24 18.5 14.98 18.39 14.79 18.21C14.61 18.02 14.5 17.76 14.5 17.5C14.5 17.24 14.61 16.98 14.79 16.79C15.16 16.42 15.84 16.42 16.21 16.79C16.39 16.98 16.5 17.24 16.5 17.5C16.5 17.76 16.39 18.02 16.21 18.21C16.02 18.39 15.76 18.5 15.5 18.5Z" fill="#002793" />
                        </svg>
                    </div>
                </div>
                <div class="db-card-body">
                    <div id="preregister-chart"></div>
                </div>
            </div>
        </div>
        <div class="col-12 lg:col-6">
            <div class="db-card">
                <div class="db-card-header">
                    <h3 class="db-card-title"><?php echo e(__('all.frontdesk_visitors')); ?></h3>
                    <div id="visitor-date-range" class="cursor-pointer flex items-center gap-3">
                        <span class="capitalize text-base font-medium text-heading"></span>
                        <svg class="fill-primary" width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M16.7502 3.56V2C16.7502 1.59 16.4102 1.25 16.0002 1.25C15.5902 1.25 15.2502 1.59 15.2502 2V3.5H8.75023V2C8.75023 1.59 8.41023 1.25 8.00023 1.25C7.59023 1.25 7.25023 1.59 7.25023 2V3.56C4.55023 3.81 3.24023 5.42 3.04023 7.81C3.02023 8.1 3.26023 8.34 3.54023 8.34H20.4602C20.7502 8.34 20.9902 8.09 20.9602 7.81C20.7602 5.42 19.4502 3.81 16.7502 3.56Z" fill="#002793" />
                            <path opacity="0.4" d="M20 9.84C20.55 9.84 21 10.29 21 10.84V17C21 20 19.5 22 16 22H8C4.5 22 3 20 3 17V10.84C3 10.29 3.45 9.84 4 9.84H20Z" fill="#002793" />
                            <path d="M8.5 15C8.24 15 7.98 14.89 7.79 14.71C7.61 14.52 7.5 14.26 7.5 14C7.5 13.74 7.61 13.48 7.79 13.29C8.07 13.01 8.51 12.92 8.88 13.08C9.01 13.13 9.12 13.2 9.21 13.29C9.39 13.48 9.5 13.74 9.5 14C9.5 14.26 9.39 14.52 9.21 14.71C9.02 14.89 8.76 15 8.5 15Z" fill="#002793" />
                            <path d="M12 15C11.74 15 11.48 14.89 11.29 14.71C11.11 14.52 11 14.26 11 14C11 13.74 11.11 13.48 11.29 13.29C11.38 13.2 11.49 13.13 11.62 13.08C11.99 12.92 12.43 13.01 12.71 13.29C12.89 13.48 13 13.74 13 14C13 14.26 12.89 14.52 12.71 14.71C12.66 14.75 12.61 14.79 12.56 14.83C12.5 14.87 12.44 14.9 12.38 14.92C12.32 14.95 12.26 14.97 12.2 14.98C12.13 14.99 12.07 15 12 15Z" fill="#002793" />
                            <path d="M15.5 15C15.24 15 14.98 14.89 14.79 14.71C14.61 14.52 14.5 14.26 14.5 14C14.5 13.74 14.61 13.48 14.79 13.29C14.89 13.2 14.99 13.13 15.12 13.08C15.3 13 15.5 12.98 15.7 13.02C15.76 13.03 15.82 13.05 15.88 13.08C15.94 13.1 16 13.13 16.06 13.17C16.11 13.21 16.16 13.25 16.21 13.29C16.39 13.48 16.5 13.74 16.5 14C16.5 14.26 16.39 14.52 16.21 14.71C16.16 14.75 16.11 14.79 16.06 14.83C16 14.87 15.94 14.9 15.88 14.92C15.82 14.95 15.76 14.97 15.7 14.98C15.63 14.99 15.56 15 15.5 15Z" fill="#002793" />
                            <path d="M8.5 18.5C8.37 18.5 8.24 18.47 8.12 18.42C7.99 18.37 7.89 18.3 7.79 18.21C7.61 18.02 7.5 17.76 7.5 17.5C7.5 17.24 7.61 16.98 7.79 16.79C7.89 16.7 7.99 16.63 8.12 16.58C8.3 16.5 8.5 16.48 8.7 16.52C8.76 16.53 8.82 16.55 8.88 16.58C8.94 16.6 9 16.63 9.06 16.67C9.11 16.71 9.16 16.75 9.21 16.79C9.39 16.98 9.5 17.24 9.5 17.5C9.5 17.76 9.39 18.02 9.21 18.21C9.16 18.25 9.11 18.3 9.06 18.33C9 18.37 8.94 18.4 8.88 18.42C8.82 18.45 8.76 18.47 8.7 18.48C8.63 18.49 8.57 18.5 8.5 18.5Z" fill="#002793" />
                            <path d="M12 18.5C11.74 18.5 11.48 18.39 11.29 18.21C11.11 18.02 11 17.76 11 17.5C11 17.24 11.11 16.98 11.29 16.79C11.66 16.42 12.34 16.42 12.71 16.79C12.89 16.98 13 17.24 13 17.5C13 17.76 12.89 18.02 12.71 18.21C12.52 18.39 12.26 18.5 12 18.5Z" fill="#002793" />
                            <path d="M15.5 18.5C15.24 18.5 14.98 18.39 14.79 18.21C14.61 18.02 14.5 17.76 14.5 17.5C14.5 17.24 14.61 16.98 14.79 16.79C15.16 16.42 15.84 16.42 16.21 16.79C16.39 16.98 16.5 17.24 16.5 17.5C16.5 17.76 16.39 18.02 16.21 18.21C16.02 18.39 15.76 18.5 15.5 18.5Z" fill="#002793" />
                        </svg>
                    </div>
                </div>
                <div class="db-card-body">
                    <div id="visitor-chart"></div>
                </div>
            </div>
        </div>
        <?php if(auth()->user()->getrole->id == \App\Enums\UserRole::ADMIN): ?>
        <div class="col-12 xl:col-6">
            <div class="db-card">
                <div class="db-card-header">
                    <h3 class="db-card-title"><?php echo e(__('all.visitor_stats')); ?></h3>
                    <div id="visitor-state-date-range" class="cursor-pointer flex items-center gap-3">
                        <span class="capitalize text-base font-medium text-heading"></span>
                        <svg class="fill-primary" width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M16.7502 3.56V2C16.7502 1.59 16.4102 1.25 16.0002 1.25C15.5902 1.25 15.2502 1.59 15.2502 2V3.5H8.75023V2C8.75023 1.59 8.41023 1.25 8.00023 1.25C7.59023 1.25 7.25023 1.59 7.25023 2V3.56C4.55023 3.81 3.24023 5.42 3.04023 7.81C3.02023 8.1 3.26023 8.34 3.54023 8.34H20.4602C20.7502 8.34 20.9902 8.09 20.9602 7.81C20.7602 5.42 19.4502 3.81 16.7502 3.56Z" fill="#002793" />
                            <path opacity="0.4" d="M20 9.84C20.55 9.84 21 10.29 21 10.84V17C21 20 19.5 22 16 22H8C4.5 22 3 20 3 17V10.84C3 10.29 3.45 9.84 4 9.84H20Z" fill="#002793" />
                            <path d="M8.5 15C8.24 15 7.98 14.89 7.79 14.71C7.61 14.52 7.5 14.26 7.5 14C7.5 13.74 7.61 13.48 7.79 13.29C8.07 13.01 8.51 12.92 8.88 13.08C9.01 13.13 9.12 13.2 9.21 13.29C9.39 13.48 9.5 13.74 9.5 14C9.5 14.26 9.39 14.52 9.21 14.71C9.02 14.89 8.76 15 8.5 15Z" fill="#002793" />
                            <path d="M12 15C11.74 15 11.48 14.89 11.29 14.71C11.11 14.52 11 14.26 11 14C11 13.74 11.11 13.48 11.29 13.29C11.38 13.2 11.49 13.13 11.62 13.08C11.99 12.92 12.43 13.01 12.71 13.29C12.89 13.48 13 13.74 13 14C13 14.26 12.89 14.52 12.71 14.71C12.66 14.75 12.61 14.79 12.56 14.83C12.5 14.87 12.44 14.9 12.38 14.92C12.32 14.95 12.26 14.97 12.2 14.98C12.13 14.99 12.07 15 12 15Z" fill="#002793" />
                            <path d="M15.5 15C15.24 15 14.98 14.89 14.79 14.71C14.61 14.52 14.5 14.26 14.5 14C14.5 13.74 14.61 13.48 14.79 13.29C14.89 13.2 14.99 13.13 15.12 13.08C15.3 13 15.5 12.98 15.7 13.02C15.76 13.03 15.82 13.05 15.88 13.08C15.94 13.1 16 13.13 16.06 13.17C16.11 13.21 16.16 13.25 16.21 13.29C16.39 13.48 16.5 13.74 16.5 14C16.5 14.26 16.39 14.52 16.21 14.71C16.16 14.75 16.11 14.79 16.06 14.83C16 14.87 15.94 14.9 15.88 14.92C15.82 14.95 15.76 14.97 15.7 14.98C15.63 14.99 15.56 15 15.5 15Z" fill="#002793" />
                            <path d="M8.5 18.5C8.37 18.5 8.24 18.47 8.12 18.42C7.99 18.37 7.89 18.3 7.79 18.21C7.61 18.02 7.5 17.76 7.5 17.5C7.5 17.24 7.61 16.98 7.79 16.79C7.89 16.7 7.99 16.63 8.12 16.58C8.3 16.5 8.5 16.48 8.7 16.52C8.76 16.53 8.82 16.55 8.88 16.58C8.94 16.6 9 16.63 9.06 16.67C9.11 16.71 9.16 16.75 9.21 16.79C9.39 16.98 9.5 17.24 9.5 17.5C9.5 17.76 9.39 18.02 9.21 18.21C9.16 18.25 9.11 18.3 9.06 18.33C9 18.37 8.94 18.4 8.88 18.42C8.82 18.45 8.76 18.47 8.7 18.48C8.63 18.49 8.57 18.5 8.5 18.5Z" fill="#002793" />
                            <path d="M12 18.5C11.74 18.5 11.48 18.39 11.29 18.21C11.11 18.02 11 17.76 11 17.5C11 17.24 11.11 16.98 11.29 16.79C11.66 16.42 12.34 16.42 12.71 16.79C12.89 16.98 13 17.24 13 17.5C13 17.76 12.89 18.02 12.71 18.21C12.52 18.39 12.26 18.5 12 18.5Z" fill="#002793" />
                            <path d="M15.5 18.5C15.24 18.5 14.98 18.39 14.79 18.21C14.61 18.02 14.5 17.76 14.5 17.5C14.5 17.24 14.61 16.98 14.79 16.79C15.16 16.42 15.84 16.42 16.21 16.79C16.39 16.98 16.5 17.24 16.5 17.5C16.5 17.76 16.39 18.02 16.21 18.21C16.02 18.39 15.76 18.5 15.5 18.5Z" fill="#002793" />
                        </svg>
                    </div>
                </div>
                <div class="db-card-body">
                    <div id="visitor-state"></div>
                </div>
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('js'); ?>
<script>
    var getTotalPreregisterUrl = "<?php echo e(route('admin.get.total.preregister')); ?>";
    var getVisitorUrl = "<?php echo e(route('admin.get.total.visitor')); ?>";
    var getVisitorStateUrl = "<?php echo e(route('admin.get.total.visitor.state')); ?>";

</script>
<script defer src="<?php echo e(asset('backend/lib/apexcharts/apexcharts.min.js')); ?>"></script>
<script src="<?php echo e(asset('js/dashboard/preregisterchart.js')); ?>"></script>
<script src="<?php echo e(asset('js/dashboard/visitorchart.js')); ?>"></script>
<script src="<?php echo e(asset('js/dashboard/visitorstatechart.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/kawsaruddin/Workspace/8.2/quickpass/resources/views/admin/dashboard/index.blade.php ENDPATH**/ ?>