<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="custome-breadcrumb">
            <?php echo e(Breadcrumbs::render('attendance')); ?>

        </div>
    </div>
    <div class="col-12">
        <div class="db-card">
            <div class="border-none db-card-header">
                <h3 class="db-card-title"><?php echo e(__('all.attendance')); ?></h3>
                <div class="db-card-filter">
                    <?php if(!blank($attendance)): ?>
                    <div class="db-card-filter">
                        <?php if(!$attendance->checkout_time): ?>
                        <form action="<?php echo e(route('admin.attendance.clockout')); ?>" method="post"> <?php echo e(csrf_field()); ?>

                            <button type="submit" class="db-btn h-[37px] text-white bg-primary">
                                <i class="fa-solid fa-circle-plus"></i>
                                <span> <?php echo e(__('all.clock_out')); ?></span>
                            </button>
                        </form>
                        <?php endif; ?>
                    </div>
                    <?php else: ?>
                    <div class="db-card-filter">
                        <button type="button" data-modal="#modal-content" class="db-btn h-[38px] text-white bg-primary">
                            <i class="fa-solid fa-circle-plus"></i>
                            <?php echo e(__('all.clock_in')); ?>

                        </button>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
            <div class="db-table-responsive">
                <table class="table db-table stripe" id="maintable" data-url="<?php echo e(route('admin.attendance.get-attendance')); ?>" data-hidecolumn="<?php echo e(auth()->user()->can('attendance_delete')); ?>">
                    <thead class="db-table-head">
                        <tr class="db-table-head-tr">
                            <th class="db-table-head-th"><?php echo e(__('all.user')); ?></th>
                            <th class="db-table-head-th"><?php echo e(__('all.working')); ?></th>
                            <th class="db-table-head-th"><?php echo e(__('all.date')); ?></th>
                            <th class="db-table-head-th"><?php echo e(__('all.clock_in')); ?></th>
                            <th class="db-table-head-th"><?php echo e(__('all.clock_out')); ?></th>
                            <th class="db-table-head-th"><?php echo e(__('all.actions')); ?></th>
                        </tr>
                    </thead>
                </table>
            </div>


        </div>
    </div>
</div>
<?php echo $__env->make('admin.attendance.clockinModal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('backend/datatable/css/dataTables.tailwindcss.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js'); ?>
<script src="<?php echo e(asset('backend/datatable/js/dataTables.js')); ?>"></script>
<script src="<?php echo e(asset('backend/datatable/js/dataTables.tailwindcss.js')); ?>"></script>
<script src="<?php echo e(asset('backend/datatable/js/tailwindcss.js')); ?>"></script>
<script src="<?php echo e(asset('js/attendance/index.js')); ?>"></script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/kawsaruddin/Workspace/8.2/quickpass/resources/views/admin/attendance/index.blade.php ENDPATH**/ ?>