<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-12">
            <div class="custome-breadcrumb">
                <?php echo e(Breadcrumbs::render('visitors')); ?>

            </div>
        </div>
        <div class="col-12">
            <div class="db-card">
                <div class="border-none db-card-header">
                    <h3 class="db-card-title"><?php echo e(__('all.visitors_details')); ?></h3>
                    <div class="db-card-filter">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('visitors_create')): ?>
                            <div class="db-card-filter">
                                <a href="<?php echo e(route('admin.visitors.create')); ?>" class="db-btn h-[37px] text-white bg-primary">
                                    <i class="fa-solid fa-circle-plus"></i>
                                    <span> <?php echo e(__('all.add_visitor')); ?></span>
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="db-table-responsive">
                    <table class="table table-vcenter" id="maintable"  data-url="<?php echo e(route('admin.visitors.get-visitors')); ?>" data-status="<?php echo e(\App\Enums\Status::ACTIVE); ?>" data-hidecolumn="<?php echo e(auth()->user()->can('visitors_show') || auth()->user()->can('visitors_edit') || auth()->user()->can('visitors_delete')); ?>">
                        <thead class="db-table-head">
                            <tr class="db-table-head-tr">
                                <th class="db-table-head-th"><?php echo e(__('all.visitor_id')); ?></th>
                                <th class="db-table-head-th"><?php echo e(__('all.name')); ?></th>
                                <th class="db-table-head-th"><?php echo e(__('all.employee')); ?></th>
                                <th class="db-table-head-th"><?php echo e(__('all.check_in')); ?></th>
                                <th class="db-table-head-th"><?php echo e(__('all.check_out')); ?></th>
                                <th class="db-table-head-th"><?php echo e(__('all.status')); ?></th>
                                <th class="db-table-head-th"><?php echo e(__('all.actions')); ?></th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('backend/datatable/css/dataTables.tailwindcss.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js'); ?>
    <script src="<?php echo e(asset('backend/datatable/js/dataTables.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/datatable/js/dataTables.tailwindcss.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/datatable/js/tailwindcss.js')); ?>"></script>
    <script src="<?php echo e(asset('js/visitor/index.js')); ?>"></script>
<?php $__env->stopPush(); ?>




<?php echo $__env->make('admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/kawsaruddin/Workspace/8.2/quickpass/resources/views/admin/visitor/index.blade.php ENDPATH**/ ?>